*                                                                                  ;
 *    Reading in the 1982 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam82.raw' ;
 
 data one;
 
   infile 'F:\PSID\82FAM.DAT'  lrecl=1116 missover;
   INPUT
   V8201 1-3              V8202 4-7              V8203 8-9
   V8204 10-12            V8205 13-17            V8206 18
   V8207 19               V8208 20               V8209 21
   V8210 22               V8211 23               V8212 24
   V8213 25               V8214 26               V8215 27
   V8216 28               V8217 29-34            V8218 35
   V8219 36-39            V8220 40               V8221 41-44
   V8222 45               V8223 46-49            V8224 50
   V8225 51-54            V8226 55               V8227 56-59
   V8228 60-63            V8229 64               V8230 65-68
   V8231 69               V8232 70-73            V8233 74
   V8234 75-78            V8235 79               V8236 80-83
   V8237 84               V8238 85-88            V8239 89
   V8240 90-93            V8241 94               V8242 95-98
   V8243 99               V8244 100-103          V8245 104
   V8246 105-108          V8247 109              V8248 110
   V8249 111-112          V8250 113              V8251 114-118 .2
   V8252 119-123          V8253 124              V8254 125-127
   V8255 128              V8256 129-132          V8257 133
   V8258 134-137          V8259 138              V8260 139-142
   V8261 143              V8262 144-145          V8263 146-150
   V8264 151-155          V8265 156-160          V8266 161
   V8267 162-166          V8268 167-171          V8269 172-175
   V8270 176-179          V8271 180              V8272 181
   V8273 182-186          V8274 187              V8275 188-193
   V8276 194-199          V8277 200-204          V8278 205-209
   V8279 210-214          V8280 215-218          V8281 219-223
   V8282 224              V8283 225-231          V8284 232-236
   V8285 237              V8286 238-239          V8287 240
   V8288 241-245          V8289 246              V8290 247-250
   V8291 251-255          V8292 256-260          V8293 261-265
   V8294 266-270          V8295 271-274          V8296 275-279
   V8297 280-283          V8298 284-287          V8299 288-292
   V8300 293              V8301 294-298          V8302 299-303
   V8303 304-305          V8304 306              V8305 307-311
   V8306 312-313          V8307 314              V8308 315-319
   V8309 320-321          V8310 322              V8311 323-327
   V8312 328-329          V8313 330              V8314 331-335
   V8315 336-337          V8316 338              V8317 339-342
   V8318 343-347          V8319 348              V8320 349
   V8321 350-354          V8322 355-359          V8323 360-364
   V8324 365-369          V8325 370-374          V8326 375-379
   V8327 380-383          V8328 384-388          V8329 389-392
   V8330 393-396          V8331 397-401          V8332 402
   V8333 403              V8334 404              V8335 405-408
   V8336 409-412          V8337 413-416          V8338 417-420
   V8339 421-424          V8340 425-428          V8341 429-432
   V8342 433-436          V8343 437-440          V8344 441-444
   V8345 445-448          V8346 449-452          V8347 453-456
   V8348 457-460          V8349 461-464          V8350 465-467
   V8351 468-469          V8352 470-471          V8353 472
   V8354 473-474          V8355 475-476          V8356 477-478
   V8357 479              V8358 480              V8359 481-485
   V8360 486              V8361 487-488          V8362 489-490
   V8363 491              V8364 492              V8365 493
   V8366 494              V8367 495              V8368 496
   V8369 497              V8370 498              V8371 499
   V8372 500              V8373 501              V8374 502
   V8375 503              V8376 504              V8377 505
   V8378 506              V8379 507-509          V8380 510-512
   V8381 513-515          V8382 516              V8383 517-520
   V8384 521              V8385 522-525          V8386 526-529
   V8387 530-533          V8388 534              V8389 535-538
   V8390 539-541          V8391 542              V8392 543
   V8393 544              V8394 545-546          V8395 547
   V8396 548-549          V8397 550              V8398 551-552
   V8399 553              V8400 554-555          V8401 556
   V8402 557-558          V8403 559-560          V8404 561-562
   V8405 563              V8406 564              V8407 565-566
   V8408 567              V8409 568-571          V8410 572-573
   V8411 574-575          V8412 576-577          V8413 578-579
   V8414 580-582          V8415 583              V8416 584
   V8417 585              V8418 586              V8419 587
   V8420 588-589          V8421 590-591          V8422 592-594
   V8423 595              V8424 596              V8425 597
   V8426 598              V8427 599              V8428 600-601
   V8429 602-603          V8430 604-606          V8431 607
   V8432 608              V8433 609              V8434 610
   V8435 611              V8436 612              V8437 613-614
   V8438 615              V8439 616-617          V8440 618-619
   V8441 620              V8442 621-622          V8443 623-624
   V8444 625              V8445 626              V8446 627
   V8447 628              V8448 629-632          V8449 633
   V8450 634              V8451 635              V8452 636
   V8453 637              V8454 638-639          V8455 640
   V8456 641              V8457 642              V8458 643-644
   V8459 645              V8460 646-647          V8461 648-649
   V8462 650              V8463 651              V8464 652
   V8465 653-656          V8466 657-658          V8467 659
   V8468 660-662          V8469 663-665          V8470 666
   V8471 667-668          V8472 669              V8473 670-671
   V8474 672              V8475 673-674          V8476 675
   V8477 676-677          V8478 678              V8479 679-680
   V8480 681              V8481 682-683          V8482 684-685
   V8483 686-687          V8484 688-689          V8485 690-691
   V8486 692-694          V8487 695              V8488 696
   V8489 697              V8490 698              V8491 699
   V8492 700-701          V8493 702-703          V8494 704-706
   V8495 707              V8496 708              V8497 709
   V8498 710              V8499 711              V8500 712-713
   V8501 714-715          V8502 716-718          V8503 719
   V8504 720              V8505 721              V8506 722
   V8507 723              V8508 724              V8509 725-726
   V8510 727              V8511 728-729          V8512 730-731
   V8513 732              V8514 733-734          V8515 735-736
   V8516 737              V8517 738              V8518 739
   V8519 740              V8520 741-742          V8521 743
   V8522 744-745          V8523 746              V8524 747-748
   V8525 749              V8526 750-752          V8527 753-755
   V8528 756-757          V8529 758-759          V8530 760
   V8531 761              V8532 762              V8533 763-764
   V8534 765              V8535 766              V8536 767
   V8537 768              V8538 769              V8539 770
   V8540 771              V8541 772              V8542 773
   V8543 774-776          V8544 777-779          V8545 780-782
   V8546 783              V8547 784-787          V8548 788-791
   V8549 792              V8550 793-795          V8551 796
   V8552 797              V8553 798-799          V8554 800
   V8555 801-802          V8556 803              V8557 804-805
   V8558 806              V8559 807-808          V8560 809
   V8561 810-811          V8562 812-813          V8563 814-815
   V8564 816              V8565 817              V8566 818-819
   V8567 820-821          V8568 822-823          V8569 824-825
   V8570 826-827          V8571 828              V8572 829
   V8573 830-831          V8574 832              V8575 833-835
   V8576 836-838          V8577 839              V8578 840-841
   V8579 842              V8580 843-844          V8581 845
   V8582 846-847          V8583 848              V8584 849-850
   V8585 851              V8586 852-853          V8587 854
   V8588 855-856          V8589 857-858          V8590 859-860
   V8591 861              V8592 862-863          V8593 864
   V8594 865-867          V8595 868-870          V8596 871-872
   V8597 873-874          V8598 875              V8599 876
   V8600 877              V8601 878              V8602 879
   V8603 880              V8604 881              V8605 882
   V8606 883              V8607 884              V8608 885
   V8609 886              V8610 887              V8611 888
   V8612 889              V8613 890              V8614 891
   V8615 892              V8616 893              V8617 894
   V8618 895              V8619 896              V8620 897
   V8621 898              V8622 899-900          V8623 901
   V8624 902              V8625 903              V8626 904
   V8627 905              V8628 906              V8629 907-908
   V8630 909-910          V8631 911-912          V8632 913
   V8633 914              V8634 915-916          V8635 917-919
   V8636 920-921          V8637 922-924          V8638 925
   V8639 926              V8640 927              V8641 928-929
   V8642 930-931          V8643 932-933          V8644 934-935
   V8645 936              V8646 937              V8647 938
   V8648 939              V8649 940-941          V8650 942-944
   V8651 945              V8652 946              V8653 947
   V8654 948              V8655 949              V8656 950
   V8657 951              V8658 952              V8659 953-954
   V8660 955-956          V8661 957-958          V8662 959
   V8663 960-961          V8664 962              V8665 963
   V8666 964              V8667 965              V8668 966
   V8669 967              V8670 968              V8671 969
   V8672 970              V8673 971              V8674 972
   V8675 973-974          V8676 975-979          V8677 980-981
   V8678 982-985          V8679 986-987          V8680 988-991
   V8681 992-993          V8682 994-997          V8683 998-999
   V8684 1000-1003        V8685 1004-1005        V8686 1006-1009
   V8687 1010-1011        V8688 1012-1016        V8689 1017-1023
   V8690 1024-1028        V8691 1029-1032 .2     V8692 1033-1036
   V8693 1037-1040 .2     V8694 1041-1044 .2     V8695 1045
   V8696 1046             V8697 1047             V8698 1048
   V8699 1049             V8700 1050             V8701 1051-1052
   V8702 1053-1054        V8703 1055-1059        V8704 1060
   V8705 1061-1062 .1     V8706 1063-1064        V8707 1065
   V8708 1066             V8709 1067             V8710 1068
   V8711 1069             V8712 1070             V8713 1071
   V8714 1072             V8715 1073             V8716 1074
   V8717 1075             V8718 1076             V8719 1077
   V8720 1078             V8721 1079             V8722 1080
   V8723 1081             V8724 1082             V8725 1083-1085
   V8726 1086             V8727 1087-1088        V8728 1089
   V8729 1090-1093        V8730 1094-1095        V8731 1096
   V8732 1097             V8733 1098-1101        V8734 1102-1105
   V8735 1106             V8736 1107-1110        V8737 1111
   V8738 1112-1115        V8739 1116;

* SAS LABEL STATEMENT;

LABEL
   V8201 = "STUDY NUMBER (701)"
   V8202 = "1982 INTERVIEW NUMBER"
   V8203 = "CURRENT STATE"
   V8204 = "CURRENT COUNTY"
   V8205 = "CURRENT STATE& CNTY"
   V8206 = "SIZE LGST CITY/SMSA-1982"
   V8207 = "COLOR COVERSHEET-1982"
   V8208 = "WHETHER REFUSED-1982"
   V8209 = "TELEPHONE INT?-1982"
   V8210 = "FAM COMP CHANGE-1982"
   V8211 = "#MOVED IN-1982"
   V8212 = "WHO MOVED IN-1982"
   V8213 = "# MOVED OUT-1982"
   V8214 = "WHO MOVED OUT-1982"
   V8215 = "CURRENT FAM COMP-1982"
   V8216 = "QUALITY OF MATCH-1982"
   V8217 = "1982 HOUSE VALUE (B6)"
   V8218 = "ACC 1982 HOUSE VALUE"
   V8219 = "ANN PROPERTY TAX 81 (B7)"
   V8220 = "ACC ANN PROPERTY TX-1982"
   V8221 = "ANN RENT-1982 (B9)"
   V8222 = "ACC ANN RENT-1982"
   V8223 = "ANN VALUE IF RENTED/B14"
   V8224 = "ACC ANN VALUEIF RENTED"
   V8225 = "COST OF HEAT/ELEC/H2O"
   V8226 = "ACC HEAT/ELEC/H2O"
   V8227 = "GOVT SUBSIDY-HTG COST/B4"
   V8228 = "HD ANN WRK HRS IN 1981"
   V8229 = "ACC HD 81 WORK HRS"
   V8230 = "HD HRS WRK LOST OTR ILL"
   V8231 = "ACC HD HR LOST OTR ILL"
   V8232 = "HD HRS WRK LOST OWN ILL"
   V8233 = "ACC HD HRS LOST OWN ILL"
   V8234 = "HD STRIKE HOURS 1981"
   V8235 = "ACC HD STRIKE HRS 1981"
   V8236 = "HD UNEMP HRS 1981"
   V8237 = "ACC HD UNEMP HRS 1981"
   V8238 = "WF ANN WRK HRS IN 1981"
   V8239 = "ACC WF 81 WRK HRS"
   V8240 = "WF HRS WRK LOST OTR ILL"
   V8241 = "ACC WF HR LOST OTR ILL"
   V8242 = "WF HRS WRK LOST OWN ILL"
   V8243 = "ACC WF HRS LOST OWN ILL"
   V8244 = "WF STRIKE HOURS 1981"
   V8245 = "ACC WF STRIKE HRS 1981"
   V8246 = "WF UNEMP HRS 1981"
   V8247 = "ACC WF UNEMP HRS 1981"
   V8248 = "# MAJOR ADULTS"
   V8249 = "1982 FAMILY SIZE"
   V8250 = "# REQUIRED ROOMS"
   V8251 = "1982 WEEKLY FOOD NEEDS"
   V8252 = "1982 ANNUAL NEED STD"
   V8253 = "# PERSONS GOT FOOD STAMP"
   V8254 = "VALUE FD ST LAST MO(J6)"
   V8255 = "ACC VALUE FD ST LAST MO"
   V8256 = "ANN FOOD COST EXC FD ST"
   V8257 = "ACC ANN FOOD COST"
   V8258 = "ANNUAL EATING OUT COST"
   V8259 = "ACC ANN EAT OUT COST"
   V8260 = "VALUE FD ST 1981 (J16)"
   V8261 = "ACC VALUE FD ST 1981"
   V8262 = "# MOS USED FD ST 1981"
   V8263 = "LABOR PART FARM Y 1981"
   V8264 = "LABOR PART BUS Y 1981"
   V8265 = "HEAD 1981 WAGES"
   V8266 = "ACC HEAD 1981 WAGES"
   V8267 = "HD BONUS/OT/COMM 1981"
   V8268 = "HD PROF PRAC/TRADE 1981"
   V8269 = "LABOR PT MKT GRDNG 1981"
   V8270 = "LABOR PT ROOMERS 1981"
   V8271 = "ACC HD LABOR Y EX WAGES"
   V8272 = "HD HRS VS Y CHKPNT(K14)"
   V8273 = "WIFE 1981 LABOR/WAGE"
   V8274 = "ACC WF 80 LABOR/WAGE"
   V8275 = "ASSET PART FARM Y 1981"
   V8276 = "ASSET PART BUS Y 1981"
   V8277 = "ASSET PT MKT GRDNG 1981"
   V8278 = "ASSET PT ROOMERS 1981"
   V8279 = "HD RENT/INT/DIVDNDS 1981"
   V8280 = "ALIMONY Y HEAD 1981"
   V8281 = "WF 1981 OTHER ASSET Y"
   V8282 = "ACC H+W 1981 ASSET Y"
   V8283 = "H+W 1981 TAXABLE Y"
   V8284 = "H+W 1981 SUPP OTR NONFU"
   V8285 = "H+W 1981 # DEPENDENTS"
   V8286 = "H+W TOTAL 1981 EXEMPTION"
   V8287 = "1981 TAX TABLE USED-H+W"
   V8288 = "H+W 1981 ADC/AFDC"
   V8289 = "ACC H+W 1981 ADC/AFDC"
   V8290 = "H+W 1981 SSI"
   V8291 = "H+W 1981 OTR WELFARE"
   V8292 = "H+W 1981 SOCIAL SECURITY"
   V8293 = "HD OTHER RETIREMENT 1981"
   V8294 = "HD 1981 UNEMPLMT COMP"
   V8295 = "HD 1981 WORKMANS COMP"
   V8296 = "HD 1981 CHILD SUPPORT"
   V8297 = "HD 1981 HELP FROM RELS"
   V8298 = "HD 1981 OTHER TRANSFER Y"
   V8299 = "WF 1981 OTHER TRANSFER Y"
   V8300 = "ACC H+W 1981 TRAN YNOADC"
   V8301 = "H+W 1981 TOT TRANSFER Y"
   V8302 = "TXBL Y 1ST XTRA EARNER"
   V8303 = "# EXEMP 1ST XTRA EARNER"
   V8304 = "TAX TABLE 1ST XTRA EARNR"
   V8305 = "TXBL Y 2ND XTRA EARNER"
   V8306 = "# EXEMP 2ND XTRA EARNER"
   V8307 = "TAX TABLE 2ND XTRA EARNR"
   V8308 = "TXBL Y 3RD XTRA EARNER"
   V8309 = "# EXEMP 3RD XTRA EARNER"
   V8310 = "TAX TABLE 3RD XTRA EARNR"
   V8311 = "TXBL Y 4TH XTRA EARNER"
   V8312 = "# EXEMP 4TH XTRA EARNER"
   V8313 = "TAX TABLE 4TH XTRA EARNR"
   V8314 = "TXBL Y 5TH XTRA EARNER"
   V8315 = "# EXEMP 5TH XTRA EARNER"
   V8316 = "TAX TABLE 5TH XTRA EARNR"
   V8317 = "OTRS 1981 ANN WRK HRS"
   V8318 = "OTR 1981 TOT ANN TXBL Y"
   V8319 = "ACC OTR ANN TXBL Y-1981"
   V8320 = "BKT OTR 1981 ASSET Y"
   V8321 = "OTR 1981 ADC/AFDC"
   V8322 = "OTR 1981 SSI"
   V8323 = "OTR 1981 OTHR WELFARE"
   V8324 = "OTR 1981 SOCIAL SECURITY"
   V8325 = "OTR 1981 OTR RETIREMENT"
   V8326 = "OTR 1981 UNEMPL COMP"
   V8327 = "OTR 1981 WORKERS COMP"
   V8328 = "OTR 1981 CHILD SUPPORT"
   V8329 = "OTR 1981 HELP FR RELS"
   V8330 = "OTR 1981 MISC TRANSFERS"
   V8331 = "OTR 1981 TOT TRANSFER Y"
   V8332 = "ACC OTR 1981 TRANSFERS"
   V8333 = "# OTR Y RECEIVERS-1981"
   V8334 = "# OTR LABOR Y RECRS-1981"
   V8335 = "1968 ID"
   V8336 = "1969 ID"
   V8337 = "1970 ID"
   V8338 = "1971 ID"
   V8339 = "1972 ID"
   V8340 = "1973 ID"
   V8341 = "1974 ID"
   V8342 = "1975 ID"
   V8343 = "1976 ID"
   V8344 = "1977 ID"
   V8345 = "1978 ID"
   V8346 = "1979 ID"
   V8347 = "1980 ID"
   V8348 = "1981 ID"
   V8349 = "DATE OF 1982 INT"
   V8350 = "LENGTH OF 1982 INT"
   V8351 = "# IN FU"
   V8352 = "AGE OF 1982 HEAD"
   V8353 = "SEX OF 1982 HEAD"
   V8354 = "AGE OF 1982 WIFE"
   V8355 = "# CHILDREN IN FU"
   V8356 = "AGE YOUNGEST CHILD"
   V8357 = "A2 WTR OWN CAR/TRUCK"
   V8358 = "A3 #CARS/TRUCKS OWNED"
   V8359 = "A4 # MI DRIVEN-ALL CARS"
   V8360 = "B1 ACTUAL # ROOMS"
   V8361 = "B2 TYPE FUEL FOR HEAT:1"
   V8362 = "B2 TYPE FUEL FOR HEAT:2"
   V8363 = "B3 RECD GOVT HTNG SUBSDY"
   V8364 = "B5 OWN/RENT OR WHAT"
   V8365 = "PAY FOR HEAT/ELEC/H2O?"
   V8366 = "B12 HEAT INCLUDED?"
   V8367 = "B13 WHY NOT OWN/RENT"
   V8368 = "B15 PAY FOR HEAT/ELEC/H2"
   V8369 = "B17 MOVD SINCE SPR 1981?"
   V8370 = "B18 WHY MOVED"
   V8371 = "B19 WTR MIGHT MOVE"
   V8372 = "B20 LIKELIHOOD OF MOVING"
   V8373 = "B21 WHY MIGHT MOVE"
   V8374 = "C1 EMPLMT STATUS-HEAD"
   V8375 = "C2 WORK SELF/OTR?(HD-E)"
   V8376 = "C3 WORK FOR GOVT?(HD-E)"
   V8377 = "C4 IS JOB NOW UNION(H-E)"
   V8378 = "C5 BELONG UNION? (HD-E)"
   V8379 = "C6 # MOS THIS EMP(HD-E)"
   V8380 = "C7-8 MAIN OCC:3DIG(H-E)"
   V8381 = "C9 MAIN IND:3 DIGT(H-E)"
   V8382 = "C10 SLRY/HRLY/OTR (H-E)"
   V8383 = "C11 PAY/HR-SALARY(HD-E)"
   V8384 = "C12 WTR SAL PD OT(HD-E)"
   V8385 = "C13 PAY/HR-SLRYOT(HD-E)"
   V8386 = "C14 PAY/HR-HOURLY(HD-E)"
   V8387 = "C15 PAY/HR-HRLY OT(H-E)"
   V8388 = "C16 HOW PAID-OTR (HD-E)"
   V8389 = "C17 PAY/HR-OTR OT (H-E)"
   V8390 = "C18 # MOS THIS JOB(H-E)"
   V8391 = "C20 HPND PREV JOB(HD-E)"
   V8392 = "C21 JOB BETTER?  (HD-E)"
   V8393 = "C22 WTR OTRS ILL (HD-E)"
   V8394 = "C23 # WKS OTR ILL(HD-E)"
   V8395 = "C24 WTR SELF ILL (HD-E)"
   V8396 = "C25 # WKS SELF ILL(HD-E)"
   V8397 = "C26 WTR VACATION (HD-E)"
   V8398 = "C27 # WK VACATION(HD-E)"
   V8399 = "C28 WTR STRIKE   (HD-E)"
   V8400 = "C29 # WK ON STRIKE(H-E)"
   V8401 = "C30 WTR UNEMPLOYD(HD-E)"
   V8402 = "C31 # WK UNEMPLYD(HD-E)"
   V8403 = "C32 # WKS WORKED (HD-E)"
   V8404 = "C33 # HR/WK WRKD (HD-E)"
   V8405 = "C34 WTR WRK OT   (HD-E)"
   V8406 = "C36 WTR XTRA JOBS(HD-E)"
   V8407 = "C37 OCC-XTRA JOBS (HD-E)"
   V8408 = "C37-C38 # XTRA JOB(H-E)"
   V8409 = "C39 PAY/HR XTRA JB(H-E)"
   V8410 = "C40 # WKS XTRA JOB(H-E)"
   V8411 = "C41 HR/WK XTRA JOB(H-E)"
   V8412 = "C43 MNTH LST UNEMP(H-E)"
   V8413 = "C43 YEAR LAST UNEMP(H-E)"
   V8414 = "C44 #WK UNEMP-LST(HD-E)"
   V8415 = "C45 WTR 4+ WK-LST(HD-E)"
   V8416 = "C46 WTR 4+ WK-LST(HD-E)"
   V8417 = "C47 4+ WK >ONCE?1(HD-E)"
   V8418 = "C48 # X NO LOOK-1(HD-E)"
   V8419 = "C50 WTR 2ND UNEMP(HD-E)"
   V8420 = "C51 MNTH 2ND UNEM(H-E)"
   V8421 = "C51 YEAR 2ND UNEMP(H-E)"
   V8422 = "C52 #WK UNEMP-2ND(HD-E)"
   V8423 = "C53 WTR 4+ WK-2ND(HD-E)"
   V8424 = "C54 WTR 4+ WK-2ND(HD-E)"
   V8425 = "C55 4+ WK >ONCE?2(HD-E)"
   V8426 = "C56 # X NO LOOK-2(HD-E)"
   V8427 = "C57 WTR 3RD UNEMP(HD-E)"
   V8428 = "C58 MNTH 3RD UNEMP(H-E)"
   V8429 = "C58 YEAR 3RD UNEMP(H-E)"
   V8430 = "C59 #WK UNEMP-3RD(HD-E)"
   V8431 = "C60 WTR 4+ WK-3RD(HD-E)"
   V8432 = "C61 WTR 4+ WK-3RD(HD-E)"
   V8433 = "C62 4+ WK >ONCE?3(HD-E)"
   V8434 = "C63 # X NO LOOK-3(HD-E)"
   V8435 = "C64 WTR REC UNEMP(HD-E)"
   V8436 = "C65 USE UP BENEFIT?(H-E)"
   V8437 = "C66 #WK NO BENEFIT(H-E)"
   V8438 = "C67 WTR ELIG UNEM(HD-E)"
   V8439 = "C68 WHY NO UNEMP-1(H-E)"
   V8440 = "C68 WHY NO UNEMP-2(H-E)"
   V8441 = "C69 OTR Y/UNEMP? (HD-E)"
   V8442 = "C70 TYPE OTR Y-1 (HD-E)"
   V8443 = "C70 TYPE OTR Y-2 (HD-E)"
   V8444 = "C71 RET SAME EMPLR(H-E)"
   V8445 = "C72 RET SAME JOB?(HD-E)"
   V8446 = "C73 RET SAME PAY?(HD-E)"
   V8447 = "C74 MRE WRK AVAILB(H-E)"
   V8448 = "C75 PAY/HR WRK MOR(H-E)"
   V8449 = "C76 COULD WRK LESS(H-E)"
   V8450 = "C77 WANT WRK LESS?(H-E)"
   V8451 = "C78 WANT WRK MORE?(H-E)"
   V8452 = "C79 COULD WRK LESS(H-E)"
   V8453 = "C80 WANT WRK LESS?(H-E)"
   V8454 = "C81 # MI TO WORK (HD-E)"
   V8455 = "C82 GET NEW JOB? (HD-E)"
   V8456 = "C83 WHAT DO-NEW JB(H-E)"
   V8457 = "C84 HD AGE 45-64?(HD-E)"
   V8458 = "C85 AGE PLAN RETR(HD-E)"
   V8459 = "C86 RET BEFORE 65?(H-E)"
   V8460 = "C87 AGE PLAN RETR(HD-E)"
   V8461 = "D1 OCC-JOB SOUGHT(HD-U)"
   V8462 = "D2 WTR NEED TRAING(H-U)"
   V8463 = "D3 WTR LOOKNG JOB(HD-U)"
   V8464 = "D4 # PLAC LOOKED (HD-U)"
   V8465 = "D5 RESERVATN WAGE(HD-U)"
   V8466 = "D6 #WKS LOOK WORK(HD-U)"
   V8467 = "D7 EVER HAD JOB? (HD-U)"
   V8468 = "D8 OCC-LAST JOB  (HD-U)"
   V8469 = "D9 IND-LAST JOB (HD-U)"
   V8470 = "D10 HAPPND LST JOB(H-U)"
   V8471 = "D11 YR LAST WRKD (HD-U)"
   V8472 = "D12 WTR VACATION (HD-U)"
   V8473 = "D13 #WKS VACATION(HD-U)"
   V8474 = "D14 WTR OTRS ILL (HD-U)"
   V8475 = "D15 #WKS OTRS ILL(HD-U)"
   V8476 = "D16 WTR SELF ILL (HD-U)"
   V8477 = "D17 #WKS SELF ILL(HD-U)"
   V8478 = "D18 WTR ON STRIKE(HD-U)"
   V8479 = "D19 #WKS ON STRIKE(H-U)"
   V8480 = "D20 WTR UNEMPLOYD(HD-U)"
   V8481 = "D21 #WKS UNEMPLYD(HD-U)"
   V8482 = "D22 #WKS WORKED  (HD-U)"
   V8483 = "D23 HR/WK WORKED (HD-U)"
   V8484 = "D25 MNTH LST UNEM(H-U)"
   V8485 = "D25 YEAR LST UNEMP(H-U)"
   V8486 = "D26 #WK UNEMP-LST(HD-U)"
   V8487 = "D27 WTR 4+ WK-LST(HD-U)"
   V8488 = "D28 WTR 4+ WK-LST(HD-U)"
   V8489 = "D29 4+ WK> ONCE?1(HD-U)"
   V8490 = "D30 # X NO LOOK-1(HD-U)"
   V8491 = "D32 WTR 2ND UNEMP(HD-U)"
   V8492 = "D33 MNTH 2ND UNEM(H-U)"
   V8493 = "D33 YEAR 2ND UNEM(H-U)"
   V8494 = "D34 #WK UNEMP-2ND(HD-U)"
   V8495 = "D35 WTR 4+ WK-2ND(HD-U)"
   V8496 = "D36 WTR 4+ WK-2ND(HD-U)"
   V8497 = "D37 4+ WK> ONCE?2(HD-U)"
   V8498 = "D38 # X NO LOOK-2(HD-U)"
   V8499 = "D39 WTR 3RD UNEMP(HD-U)"
   V8500 = "D40 MNTH 3RD UNEM(H-U)"
   V8501 = "D40 YEAR 3RD UNEM(H-U)"
   V8502 = "D41 #WK UNEMP-3RD(HD-U)"
   V8503 = "D42 WTR 4+ WK-3RD(HD-U)"
   V8504 = "D43 WTR 4+ WK-3RD(HD-U)"
   V8505 = "D44 4+ WK> ONCE?3(HD-U)"
   V8506 = "D45 # X NO LOOK-3(HD-U)"
   V8507 = "D46 WTR REC UNEMP(HD-U)"
   V8508 = "D47 USE UP BENEFIT(H-U)"
   V8509 = "D48 #WK NO BENEFIT(H-U)"
   V8510 = "D49 WTR ELIG UNEM(HD-U)"
   V8511 = "D50 WHY NO UNEMP-1(H-U)"
   V8512 = "D50 WHY NO UNEMP-2(H-U)"
   V8513 = "D51 OTR Y/UNEMP? (HD-U)"
   V8514 = "D52 TYPE OTR Y-1 (HD-U)"
   V8515 = "D52 TYPE OTR Y-2 (HD-U)"
   V8516 = "D53 RET SAME EMPLR(H-U)"
   V8517 = "D54 RET SAME JOB?(HD-U)"
   V8518 = "D55 RET SAME PAY?(HD-U)"
   V8519 = "D56 HD AGE 45-64?(HD-U)"
   V8520 = "D57 AGE PLAN RETR(HD-U)"
   V8521 = "D58 RET BEFORE 65?(H-U)"
   V8522 = "D59 AGE PLAN RETR(HD-U)"
   V8523 = "E1 WTR RETIRED   (HD-R)"
   V8524 = "E2 YEAR RETIRED  (HD-R)"
   V8525 = "E3 WRK FOR PAY-81?(H-R)"
   V8526 = "E4 OCCUPATION    (HD-R)"
   V8527 = "E5 INDUSTRY      (HD-R)"
   V8528 = "E6 #WKS WORKED   (HD-R)"
   V8529 = "E7 HR/WK WORKED  (HD-R)"
   V8530 = "E8 WORKING NOW?  (HD-R)"
   V8531 = "E9 HAPPND LST JOB(HD-R)"
   V8532 = "E10 JOB IN FUTURE?(H-R)"
   V8533 = "E11 WHEN GET JOB (HD-R)"
   V8534 = "E12 WTR NEED TRNG(HD-R)"
   V8535 = "E13 LOOK FOR JOB?(HD-R)"
   V8536 = "E14 #PLACES LOOKD(HD-R)"
   V8537 = "F1 WIFE IN FU?"
   V8538 = "F2 EMPLOYMENT STAT-WF"
   V8539 = "F3 WORK FOR SELF?(WF-E)"
   V8540 = "F4 WRK FOR GOVT? (WF-E)"
   V8541 = "F5 JOB UNION?    (WF-E)"
   V8542 = "F6 BELONG JOB UN?(WF-E)"
   V8543 = "F7 #MO THIS EMPLR(WF-E)"
   V8544 = "F8/9 OCCUPATION  (WF-E)"
   V8545 = "C10 INDUSTRY    (WF-E)"
   V8546 = "F11 SLRY/HRLY/OTR(WF-E)"
   V8547 = "F12 PAY/HR-SALARY(WF-E)"
   V8548 = "F13 PAY/HR-HOURLY(WF-E)"
   V8549 = "F14 HOW PAID-OTR (WF-E)"
   V8550 = "F15 #MOS THIS JOB(WF-E)"
   V8551 = "F17 HAPPND PREV JB(W-E)"
   V8552 = "F18 WTR OTRS ILL (WF-E)"
   V8553 = "F19 #WKS OTRS ILL(WF-E)"
   V8554 = "F20 WTR SELF ILL (WF-E)"
   V8555 = "F21 #WKS SELF ILL(WF-E)"
   V8556 = "F22 WTR VACATION (WF-E)"
   V8557 = "F23 #WKS VACATION(WF-E)"
   V8558 = "F24 WTR ON STRIKE(WF-E)"
   V8559 = "F25 #WKS ON STRIK(WF-E)"
   V8560 = "F26 WTR UNEMPLOYD(WF-E)"
   V8561 = "F27 #WKS UNEMPLOYD(W-E)"
   V8562 = "F28 #WKS WORKED  (WF-E)"
   V8563 = "F29 HR/WK WORKED (WF-E)"
   V8564 = "F30 WTR WRKD OT  (WF-E)"
   V8565 = "F32 WTR XTRA JOBS(WF-E)"
   V8566 = "F33 OCC-XTRA JOB (WF-E)"
   V8567 = "F34 #WKS-XTRA JOB(WF-E)"
   V8568 = "F35 HR/WK-XTRA JOB(W-E)"
   V8569 = "F36 #MI TO WORK  (WF-E)"
   V8570 = "G1 OCC-JOB SOUGHT(WF-U)"
   V8571 = "G2 WTR LOOK JOB  (WF-U)"
   V8572 = "G3 #PLACES LOOKED(WF-U)"
   V8573 = "G4 #WKS LOOK WORK(WF-U)"
   V8574 = "G5 EVER HAD JOB? (WF-U)"
   V8575 = "G6 OCC-LAST JOB  (WF-U)"
   V8576 = "G7 IND-LAST JOB  (WF-U)"
   V8577 = "G8 HAPPND LST JOB(WF-U)"
   V8578 = "G9 YEAR LAST WRKD(WF-U)"
   V8579 = "G10 WTR VACATION (WF-U)"
   V8580 = "G11 #WKS VACATION(WF-U)"
   V8581 = "G12 WTR OTRS ILL (WF-U)"
   V8582 = "G13 #WKS OTRS ILL(WF-U)"
   V8583 = "G14 WTR SELF ILL (WF-U)"
   V8584 = "G15 #WKS SELF ILL(WF-U)"
   V8585 = "G16 WTR ON STRIKE(WF-U)"
   V8586 = "G17 #WKS ON STRIK(WF-U)"
   V8587 = "G18 WTR UNEMPLOYD(WF-U)"
   V8588 = "G19 #WKS UNEMPLD (WF-U)"
   V8589 = "G20 #WKS WORKED  (WF-U)"
   V8590 = "G21 HR/WK WORKED (WF-U)"
   V8591 = "H1 WTR RETIRED   (WF-R)"
   V8592 = "H2 YEAR RETIRED  (WF-R)"
   V8593 = "H3 WRK FOR PAY-81?(W-R)"
   V8594 = "H4 OCCUPATION    (WF-R)"
   V8595 = "H5 INDUSTRY      (WF-R)"
   V8596 = "H6 # WKS WORKED  (WF-R)"
   V8597 = "H7 HR/WK WORKED  (WF-R)"
   V8598 = "H8 WTR WORK NOW  (WF-R)"
   V8599 = "H9 HAPPND PREV JOB(W-R)"
   V8600 = "H10 JOB IN FUTURE?(W-R)"
   V8601 = "H11 LOOK FOR JOB?(WF-R)"
   V8602 = "H12 #PLACES LOOKED(W-R)"
   V8603 = "J1 MARITAL STATUS"
   V8604 = "J2 WTR EVER MARRIED"
   V8605 = "J3 WHAT HAPND LST MARR"
   V8606 = "K1 WTR HEAD FARMER"
   V8607 = "K2 TOT FARM RECEIPTS BKT"
   V8608 = "K5 WHETHER BUSINESS"
   V8609 = "K6 CORP/UNINCORP BUSINES"
   V8610 = "K56 WTR LUMP SUM PAYMNTS"
   V8611 = "K57 BKT LUMP SUM PAYMNTS"
   V8612 = "K58 WTR HELP SUPPORT OTR"
   V8613 = "K59 # OTRS SUPPORTED"
   V8614 = "K61 WTR DEPENDENT OTRS"
   V8615 = "K62 # OTR DEPENDENTS"
   V8616 = "K63 WTR PHYS-NERV PROB-H"
   V8617 = "K64 HOW MUCH LIMIT-HD"
   V8618 = "K65 WTR WIFE IN FU"
   V8619 = "K66 WTR PHYS-NERV PROB-W"
   V8620 = "K67 HOW MUCH LIMIT-WF"
   V8621 = "L1 WTR NEW WIFE IN FU"
   V8622 = "L2 EDUCATION-WF"
   V8623 = "L3 WTR OTR SCHOOLING -WF"
   V8624 = "L4 TYPE OTR SCHOOLING-WF"
   V8625 = "L6 WTR BA/BS DEGREE-WF"
   V8626 = "L7 WTR ADVANCED DEG-WF"
   V8627 = "L8 EDUCATION OF FA-WF"
   V8628 = "L9 EDUCATION OF MO-WF"
   V8629 = "L10 #YRS WRK SINCE 18-WF"
   V8630 = "L11 #YRS WRKD FULLTIME-W"
   V8631 = "L12 P TIME WORKED-WF"
   V8632 = "L12 ACC P TIME WORKED-WF"
   V8633 = "M1 WTR NEW HEAD IN FU"
   V8634 = "M2 STATE FA GREW UP-HD"
   V8635 = "M2 CNTY FA GREW UP-HD"
   V8636 = "M2 STATE MO GREW UP-HD"
   V8637 = "M2 CNTY MO GREW UP-HD"
   V8638 = "M3 OCCUPATION OF FA-HD"
   V8639 = "M4 FIRST OCCUPATION-HD"
   V8640 = "M5 # DIFF JOBS OR?-HD"
   V8641 = "M6-10 AGE OLDEST KID-HD"
   V8642 = "M6-10 AGE 2ND OLD KID-HD"
   V8643 = "M6-10 AGE 3RD OLD KID-HD"
   V8644 = "M6-10 TOT # CHILDREN-HD"
   V8645 = "M6-10 # KIDS BY 25-HD"
   V8646 = "M11 # SIBLINGS-HD"
   V8647 = "M12 WTR OLDER SIBS-HD"
   V8648 = "M13 GREW UP FARM OR-HD"
   V8649 = "M14-15 STATE GREW UP-HD"
   V8650 = "M14-15 CNTY GREW UP-HD"
   V8651 = "M14-16 #REGIONS LIVED-HD"
   V8652 = "M14-16 #STATES LIVED-HD"
   V8653 = "M17 EVER MOVE FOR JOB?HD"
   V8654 = "M18 NOT MOVED FOR JOB?HD"
   V8655 = "M19 PARENTS POOR OR?-HD"
   V8656 = "M20-21 EDUC OF FATHER-H"
   V8657 = "M22-23 EDUC OF MOTHER-H"
   V8658 = "M24 WTR VETERAN-HD"
   V8659 = "M25 #YRS WRKD SINCE 18-H"
   V8660 = "M26 #YRS WRKD FULLTIME-H"
   V8661 = "M27 P TIME WORKED-HD"
   V8662 = "M27 ACC P TIME WORKED-HD"
   V8663 = "M28 EDUCATION-HD"
   V8664 = "M29 WTR OTR TRAINING-HD"
   V8665 = "M30 TYPE OTR TRAINING-HD"
   V8666 = "M31 TROUBLE READING?-HD"
   V8667 = "M32 WTR OTR SCHOOLING-HD"
   V8668 = "M33 TYPE OTR SCHOOLING-H"
   V8669 = "M35 WTR BA/BS DEGREE-HD"
   V8670 = "M36 WTR ADVANCED DEG-HD"
   V8671 = "M37 RECORD RELIG PREF?HD"
   V8672 = "M38-39 RELIGIOUS PREF-HD"
   V8673 = "TN1 WHO RESPONDENT?"
   V8674 = "TN2 # OF INTERVWR CALLS"
   V8675 = "# OF INDIVIDUAL RECORDS"
   V8676 = "H+W 1981 FED TAXES"
   V8677 = "H+W 81 MARGINAL TAX RATE"
   V8678 = "1ST XTRA ERNER 81 TAXES"
   V8679 = "MARG TAX RATE ERNR ONE"
   V8680 = "2ND XTRA ERNER 81 TAXES"
   V8681 = "MARG TAX RATE ERNR TWO"
   V8682 = "3RD XTRA ERNER 81 TAXES"
   V8683 = "MARG TAX RATE ERNR THREE"
   V8684 = "4TH XTRA ERNER 81 TAXES"
   V8685 = "MARG TAX RATE ERNR FOUR"
   V8686 = "5TH XTRA ERNER 81 TAXES"
   V8687 = "MARG TAX RATE ERNR FIVE"
   V8688 = "TOT TAXES ALL XTRA ERNR"
   V8689 = "TOT FAM $ $  Y 81"
   V8690 = "TOT HD LABOR $ $  Y 81"
   V8691 = "1981 $ $  Y/NEEDS"
   V8692 = "ANNUAL FOOD STD"
   V8693 = "HEAD 81 AVG HRLY EARNING"
   V8694 = "WIFE 81 AVG HRLY EARNING"
   V8695 = "REGION 1982 INT"
   V8696 = "REGION 82 HD GREW UP"
   V8697 = "REGION 82 HD FA GREW UP"
   V8698 = "REGION 82 HD MO GREW UP"
   V8699 = "GEOGRAPHIC MOBILITY"
   V8700 = "ACC 81 Y COMPONENTS"
   V8701 = "# MINOR ASSGMTS IN 82"
   V8702 = "# MAJOR ASSGMTS IN 82"
   V8703 = "DU VALUE/ROOM - 1982"
   V8704 = "ACTUL MINUS REQ ROOMS 82"
   V8705 = "PERSON/ROOM IN 1982"
   V8706 = "# 18 OR OLDER IN 82"
   V8707 = "BKT AGE HEAD 1982"
   V8708 = "BKT AGE WIFE 1982"
   V8709 = "EDUCATION 1982 HEAD"
   V8710 = "EDUCATION 1982 WIFE"
   V8711 = "MARITAL STATUS 1982"
   V8712 = "DECILE: 81 TOT FAM $ $  Y"
   V8713 = "DECILE: 81 $ $  Y/NEEDS"
   V8714 = "# CHILDS AGE 1-2"
   V8715 = "# CHILDS AGE 3-5"
   V8716 = "# CHILDS AGE 6-13"
   V8717 = "# FEM CHILDS 14-17"
   V8718 = "# MALE CHILDS 14-17"
   V8719 = "# FEM CHILDS 18-20"
   V8720 = "# MALE CHILDS 18-20"
   V8721 = "# FEM CHILDS 21-29"
   V8722 = "# MALE CHILDS 21-29"
   V8723 = "RACE (FROM 1972)"
   V8724 = "SPLIT SAMPLE FILTER"
   V8725 = "SAMP ERR COMP UNIT(SECU)"
   V8726 = "15YR FAM COMP CHANGE"
   V8727 = "1982 FAMILY WEIGHT"
   V8728 = "UNSKL M CNTY LABOR SUPPL"
   V8729 = "TYPICAL UNSKL WAGE RATE"
   V8730 = "1982 CNTY UNEMP RATE"
   V8731 = "81-82 CNG MARITAL STATUS"
   V8732 = "# 82 S/O FROM THIS FAM"
   V8733 = "82 MAIN FAM ID FOR S/0"
   V8734 = "82ID OF 1ST OTR FU IN HU"
   V8735 = "REL OF 1ST OTHER FU"
   V8736 = "82ID OF 2ND OTR FU IN HU"
   V8737 = "REL OF 2ND OTHER FU"
   V8738 = "82ID OF 3RD OTR FU IN HU"
   V8739 = "REL OF 3RD OTHER FU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V8203=99 THEN V8203=.;
IF V8204=999 THEN V8204=.;
IF V8205=99999 THEN V8205=.;
IF V8206=9 THEN V8206=.;
IF V8208=9 THEN V8208=.;
IF V8209=9 THEN V8209=.;
IF V8227=9999 THEN V8227=.;
IF V8253=9 THEN V8253=.;
IF V8262=99 THEN V8262=.;
IF V8284=99999 THEN V8284=.;
IF V8320=9 THEN V8320=.;
IF V8349=9999 THEN V8349=.;
IF V8350=999 THEN V8350=.;
IF V8352=99 THEN V8352=.;
IF V8354=99 THEN V8354=.;
IF V8356=99 THEN V8356=.;
IF V8357=9 THEN V8357=.;
IF V8358=9 THEN V8358=.;
IF V8359=99999 THEN V8359=.;
IF V8360=9 THEN V8360=.;
IF V8361=99 THEN V8361=.;
IF V8363=9 THEN V8363=.;
IF V8366=9 THEN V8366=.;
IF V8367=9 THEN V8367=.;
IF V8368=9 THEN V8368=.;
IF V8369=9 THEN V8369=.;
IF V8370=9 THEN V8370=.;
IF V8371=9 THEN V8371=.;
IF V8372=9 THEN V8372=.;
IF V8373=9 THEN V8373=.;
IF V8375=9 THEN V8375=.;
IF V8376=9 THEN V8376=.;
IF V8377=9 THEN V8377=.;
IF V8378=9 THEN V8378=.;
IF V8379=999 THEN V8379=.;
IF V8380=999 THEN V8380=.;
IF V8381=999 THEN V8381=.;
IF V8382=9 THEN V8382=.;
IF V8383=9999 THEN V8383=.;
IF V8384=9 THEN V8384=.;
IF V8385=9999 THEN V8385=.;
IF V8386=9999 THEN V8386=.;
IF V8387=9999 THEN V8387=.;
IF V8388=9 THEN V8388=.;
IF V8389=9999 THEN V8389=.;
IF V8390=999 THEN V8390=.;
IF V8391=9 THEN V8391=.;
IF V8392=9 THEN V8392=.;
IF V8393=9 THEN V8393=.;
IF V8394=99 THEN V8394=.;
IF V8395=9 THEN V8395=.;
IF V8396=99 THEN V8396=.;
IF V8397=9 THEN V8397=.;
IF V8398=99 THEN V8398=.;
IF V8399=9 THEN V8399=.;
IF V8400=99 THEN V8400=.;
IF V8401=9 THEN V8401=.;
IF V8402=99 THEN V8402=.;
IF V8403=99 THEN V8403=.;
IF V8404=99 THEN V8404=.;
IF V8405=9 THEN V8405=.;
IF V8406=9 THEN V8406=.;
IF V8407=99 THEN V8407=.;
IF V8408=9 THEN V8408=.;
IF V8409=9999 THEN V8409=.;
IF V8410=99 THEN V8410=.;
IF V8411=99 THEN V8411=.;
IF V8412=99 THEN V8412=.;
IF V8413=99 THEN V8413=.;
IF V8414=999 THEN V8414=.;
IF V8415=9 THEN V8415=.;
IF V8416=9 THEN V8416=.;
IF V8417=9 THEN V8417=.;
IF V8418=9 THEN V8418=.;
IF V8419=9 THEN V8419=.;
IF V8420=99 THEN V8420=.;
IF V8421=99 THEN V8421=.;
IF V8422=999 THEN V8422=.;
IF V8423=9 THEN V8423=.;
IF V8424=9 THEN V8424=.;
IF V8425=9 THEN V8425=.;
IF V8426=9 THEN V8426=.;
IF V8427=9 THEN V8427=.;
IF V8428=99 THEN V8428=.;
IF V8429=99 THEN V8429=.;
IF V8430=999 THEN V8430=.;
IF V8431=9 THEN V8431=.;
IF V8432=9 THEN V8432=.;
IF V8433=9 THEN V8433=.;
IF V8434=9 THEN V8434=.;
IF V8435=9 THEN V8435=.;
IF V8436=9 THEN V8436=.;
IF V8437=99 THEN V8437=.;
IF V8438=9 THEN V8438=.;
IF V8439=99 THEN V8439=.;
IF V8440=99 THEN V8440=.;
IF V8441=9 THEN V8441=.;
IF V8442=99 THEN V8442=.;
IF V8443=99 THEN V8443=.;
IF V8444=9 THEN V8444=.;
IF V8445=9 THEN V8445=.;
IF V8446=9 THEN V8446=.;
IF V8447=9 THEN V8447=.;
IF V8448=9999 THEN V8448=.;
IF V8449=9 THEN V8449=.;
IF V8450=9 THEN V8450=.;
IF V8451=9 THEN V8451=.;
IF V8452=9 THEN V8452=.;
IF V8453=9 THEN V8453=.;
IF V8454=99 THEN V8454=.;
IF V8455=9 THEN V8455=.;
IF V8456=9 THEN V8456=.;
IF V8457=9 THEN V8457=.;
IF V8458=99 THEN V8458=.;
IF V8459=9 THEN V8459=.;
IF V8460=99 THEN V8460=.;
IF V8461=99 THEN V8461=.;
IF V8462=9 THEN V8462=.;
IF V8463=9 THEN V8463=.;
IF V8464=9 THEN V8464=.;
IF V8465=9999 THEN V8465=.;
IF V8466=99 THEN V8466=.;
IF V8467=9 THEN V8467=.;
IF V8468=999 THEN V8468=.;
IF V8469=999 THEN V8469=.;
IF V8470=9 THEN V8470=.;
IF V8471=99 THEN V8471=.;
IF V8472=9 THEN V8472=.;
IF V8473=99 THEN V8473=.;
IF V8474=9 THEN V8474=.;
IF V8475=99 THEN V8475=.;
IF V8476=9 THEN V8476=.;
IF V8477=99 THEN V8477=.;
IF V8478=9 THEN V8478=.;
IF V8479=99 THEN V8479=.;
IF V8480=9 THEN V8480=.;
IF V8481=99 THEN V8481=.;
IF V8482=99 THEN V8482=.;
IF V8483=99 THEN V8483=.;
IF V8484=99 THEN V8484=.;
IF V8485=99 THEN V8485=.;
IF V8486=999 THEN V8486=.;
IF V8487=9 THEN V8487=.;
IF V8488=9 THEN V8488=.;
IF V8489=9 THEN V8489=.;
IF V8490=9 THEN V8490=.;
IF V8491=9 THEN V8491=.;
IF V8492=99 THEN V8492=.;
IF V8493=99 THEN V8493=.;
IF V8494=999 THEN V8494=.;
IF V8495=9 THEN V8495=.;
IF V8496=9 THEN V8496=.;
IF V8497=9 THEN V8497=.;
IF V8498=9 THEN V8498=.;
IF V8499=9 THEN V8499=.;
IF V8500=99 THEN V8500=.;
IF V8501=99 THEN V8501=.;
IF V8502=999 THEN V8502=.;
IF V8503=9 THEN V8503=.;
IF V8504=9 THEN V8504=.;
IF V8505=9 THEN V8505=.;
IF V8506=9 THEN V8506=.;
IF V8507=9 THEN V8507=.;
IF V8508=9 THEN V8508=.;
IF V8509=99 THEN V8509=.;
IF V8510=9 THEN V8510=.;
IF V8511=99 THEN V8511=.;
IF V8512=99 THEN V8512=.;
IF V8513=9 THEN V8513=.;
IF V8514=99 THEN V8514=.;
IF V8515=99 THEN V8515=.;
IF V8516=9 THEN V8516=.;
IF V8517=9 THEN V8517=.;
IF V8518=9 THEN V8518=.;
IF V8519=9 THEN V8519=.;
IF V8520=99 THEN V8520=.;
IF V8521=9 THEN V8521=.;
IF V8522=99 THEN V8522=.;
IF V8524=99 THEN V8524=.;
IF V8525=9 THEN V8525=.;
IF V8526=999 THEN V8526=.;
IF V8527=999 THEN V8527=.;
IF V8528=99 THEN V8528=.;
IF V8529=99 THEN V8529=.;
IF V8530=9 THEN V8530=.;
IF V8531=9 THEN V8531=.;
IF V8532=9 THEN V8532=.;
IF V8533=99 THEN V8533=.;
IF V8534=9 THEN V8534=.;
IF V8535=9 THEN V8535=.;
IF V8536=9 THEN V8536=.;
IF V8539=9 THEN V8539=.;
IF V8540=9 THEN V8540=.;
IF V8541=9 THEN V8541=.;
IF V8542=9 THEN V8542=.;
IF V8543=999 THEN V8543=.;
IF V8544=999 THEN V8544=.;
IF V8545=999 THEN V8545=.;
IF V8546=9 THEN V8546=.;
IF V8547=9999 THEN V8547=.;
IF V8548=9999 THEN V8548=.;
IF V8549=9 THEN V8549=.;
IF V8550=999 THEN V8550=.;
IF V8551=9 THEN V8551=.;
IF V8552=9 THEN V8552=.;
IF V8553=99 THEN V8553=.;
IF V8554=9 THEN V8554=.;
IF V8555=99 THEN V8555=.;
IF V8556=9 THEN V8556=.;
IF V8557=99 THEN V8557=.;
IF V8558=9 THEN V8558=.;
IF V8559=99 THEN V8559=.;
IF V8560=9 THEN V8560=.;
IF V8561=99 THEN V8561=.;
IF V8562=99 THEN V8562=.;
IF V8563=99 THEN V8563=.;
IF V8564=9 THEN V8564=.;
IF V8565=9 THEN V8565=.;
IF V8566=99 THEN V8566=.;
IF V8567=99 THEN V8567=.;
IF V8568=99 THEN V8568=.;
IF V8569=99 THEN V8569=.;
IF V8570=99 THEN V8570=.;
IF V8571=9 THEN V8571=.;
IF V8572=9 THEN V8572=.;
IF V8573=99 THEN V8573=.;
IF V8574=9 THEN V8574=.;
IF V8575=999 THEN V8575=.;
IF V8576=999 THEN V8576=.;
IF V8577=9 THEN V8577=.;
IF V8578=99 THEN V8578=.;
IF V8579=9 THEN V8579=.;
IF V8580=99 THEN V8580=.;
IF V8581=9 THEN V8581=.;
IF V8582=99 THEN V8582=.;
IF V8583=9 THEN V8583=.;
IF V8584=99 THEN V8584=.;
IF V8585=9 THEN V8585=.;
IF V8586=99 THEN V8586=.;
IF V8587=9 THEN V8587=.;
IF V8588=99 THEN V8588=.;
IF V8589=99 THEN V8589=.;
IF V8590=99 THEN V8590=.;
IF V8592=99 THEN V8592=.;
IF V8593=9 THEN V8593=.;
IF V8594=999 THEN V8594=.;
IF V8595=999 THEN V8595=.;
IF V8596=99 THEN V8596=.;
IF V8597=99 THEN V8597=.;
IF V8598=9 THEN V8598=.;
IF V8599=9 THEN V8599=.;
IF V8600=9 THEN V8600=.;
IF V8601=9 THEN V8601=.;
IF V8602=9 THEN V8602=.;
IF V8603=9 THEN V8603=.;
IF V8604=9 THEN V8604=.;
IF V8605=9 THEN V8605=.;
IF V8606=9 THEN V8606=.;
IF V8607=9 THEN V8607=.;
IF V8608=9 THEN V8608=.;
IF V8609=9 THEN V8609=.;
IF V8610=9 THEN V8610=.;
IF V8611=9 THEN V8611=.;
IF V8612=9 THEN V8612=.;
IF V8613=9 THEN V8613=.;
IF V8614=9 THEN V8614=.;
IF V8615=9 THEN V8615=.;
IF V8616=9 THEN V8616=.;
IF V8617=9 THEN V8617=.;
IF V8619=9 THEN V8619=.;
IF V8620=9 THEN V8620=.;
IF V8622=99 THEN V8622=.;
IF V8623=9 THEN V8623=.;
IF V8624=9 THEN V8624=.;
IF V8625=9 THEN V8625=.;
IF V8626=9 THEN V8626=.;
IF V8627=9 THEN V8627=.;
IF V8628=9 THEN V8628=.;
IF V8629=99 THEN V8629=.;
IF V8630=99 THEN V8630=.;
IF V8634=99 THEN V8634=.;
IF V8635=999 THEN V8635=.;
IF V8636=99 THEN V8636=.;
IF V8637=999 THEN V8637=.;
IF V8638=9 THEN V8638=.;
IF V8639=9 THEN V8639=.;
IF V8640=9 THEN V8640=.;
IF V8641=99 THEN V8641=.;
IF V8642=99 THEN V8642=.;
IF V8643=99 THEN V8643=.;
IF V8644=99 THEN V8644=.;
IF V8645=9 THEN V8645=.;
IF V8646=9 THEN V8646=.;
IF V8647=9 THEN V8647=.;
IF V8648=9 THEN V8648=.;
IF V8649=99 THEN V8649=.;
IF V8650=999 THEN V8650=.;
IF V8651=9 THEN V8651=.;
IF V8652=9 THEN V8652=.;
IF V8653=9 THEN V8653=.;
IF V8654=9 THEN V8654=.;
IF V8655=9 THEN V8655=.;
IF V8656=9 THEN V8656=.;
IF V8657=9 THEN V8657=.;
IF V8658=9 THEN V8658=.;
IF V8659=99 THEN V8659=.;
IF V8660=99 THEN V8660=.;
IF V8663=99 THEN V8663=.;
IF V8664=9 THEN V8664=.;
IF V8665=9 THEN V8665=.;
IF V8666=9 THEN V8666=.;
IF V8667=9 THEN V8667=.;
IF V8668=9 THEN V8668=.;
IF V8669=9 THEN V8669=.;
IF V8670=9 THEN V8670=.;
IF V8671=9 THEN V8671=.;
IF V8672=9 THEN V8672=.;
IF V8673=9 THEN V8673=.;
IF V8674=9 THEN V8674=.;
IF V8695=9 THEN V8695=.;
IF V8696=9 THEN V8696=.;
IF V8697=9 THEN V8697=.;
IF V8698=9 THEN V8698=.;
IF V8699=9 THEN V8699=.;
IF V8703=99999 THEN V8703=.;
IF V8704=9 THEN V8704=.;
IF V8705=9.9 THEN V8705=.;
IF V8707=9 THEN V8707=.;
IF V8708=9 THEN V8708=.;
IF V8709=9 THEN V8709=.;
IF V8710=9 THEN V8710=.;
IF V8723=9 THEN V8723=.;
IF V8728=9 THEN V8728=.;
IF V8729=9999 THEN V8729=.;
IF V8730=99 THEN V8730=.;
 
file rawdat lrecl=1116;
put    
v8202
v8210
v8217
v8218
v8221
v8222
v8225
v8226
v8228
v8229
v8230
v8232
v8238
v8239
v8240
v8242
v8252
v8254
v8255
v8256
v8257
v8258
v8259
v8260
v8261
v8271
v8273
v8274
v8279
v8281
v8283
v8301
v8317
v8318
v8320
v8331
v8349
v8351
v8352
v8353
v8354
v8358
v8364
v8369
v8370
v8374
v8375
v8379
v8391
v8403
v8404
v8466
v8470
v8482
v8483
v8538
v8539
v8543
v8551
v8562
v8563
v8573
v8577
v8589
v8590
v8598
v8611
v8613
v8616
v8622
v8625
v8633
v8663
v8669
v8676
v8677
v8688
v8689
v8690
v8695
v8700
v8709
v8710
v8711
v8723
v8727
v30388
;

 proc means;
 run; 
